<?php
    $logo = Utility::get_superadmin_logo();
    $logos=\App\Models\Utility::get_file('uploads/logo/');
    $lang = app()->getLocale();
    if ($lang == 'ar' || $lang == 'he') {
        $settings['SITE_RTL'] = 'on';
    }
    $LangName = \App\Models\Languages::where('code', $lang)->first();
    if (empty($LangName)) {
        $LangName = new App\Models\Utility();
        $LangName->fullName = 'English';
    }
    $setting = App\Models\Settings::colorset();
    $color = 'theme-3';
    if (!empty($setting['color'])) {
        $color = $setting['color'];
    }
    $settings = \App\Models\Utility::settings();

?>



<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Search Your Ticket')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="custom-login">
        <div class="bg-login bg-primary"></div>
        <div class="custom-login-inner">

            <nav class="navbar navbar-expand-md default">
                <div class="container pe-2">
                    <div class="navbar-brand">
                        <a href="#">
                            <img src="<?php echo e($logos . $logo . '?timestamp=' . time()); ?>"
                                alt="<?php echo e(config('app.name', 'TicketGo Saas')); ?>" alt="logo" loading="lazy"
                                class="logo" />
                        </a>
                    </div>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarlogin">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarlogin">
                        <ul class="navbar-nav align-items-center ms-auto mb-2 mb-lg-0">
                            <li class="nav-item">
                                <a class="nav-link active" href="<?php echo e(route('login')); ?>"><?php echo e(__('Agent Login')); ?></a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('home')); ?>"><?php echo e(__('Create Ticket')); ?></a>
                            </li>

                            <li class="nav-item">
                                <?php if($settings['FAQ'] == 'on'): ?>
                                    <a class="nav-link" href="<?php echo e(route('faq')); ?>"><?php echo e(__('FAQ')); ?></a>
                                <?php endif; ?>
                            </li>
                            <li class="nav-item">
                                <?php if($settings['Knowlwdge_Base'] == 'on'): ?>
                                    <a href="<?php echo e(route('knowledge')); ?>" class="nav-link"><?php echo e(__('Knowledge')); ?></a>
                                <?php endif; ?>
                            </li>

                            <div class="lang-dropdown-only-desk">
                                <li class="dropdown dash-h-item drp-language">
                                    <a class="dash-head-link dropdown-toggle btn" href="#" data-bs-toggle="dropdown"
                                        aria-expanded="false">
                                        <span class="drp-text"> <?php echo e(ucfirst($LangName->fullName)); ?>

                                        </span>
                                    </a>
                                    <div class="dropdown-menu dash-h-dropdown dropdown-menu-end">
                                        <?php $__currentLoopData = App\Models\Utility::languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(route('login', $code)); ?>" tabindex="0"
                                                class="dropdown-item dropdown-item <?php echo e($LangName->code == $code ? 'active' : ''); ?>">
                                                <span><?php echo e(ucFirst($language)); ?></span>
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </li>
                            </div>
                        </ul>
                    </div>
                </div>
            </nav>

            <main class="custom-wrapper">
                <div class="custom-row">
                    <div class="col-xl-7 col-12">
                        <div class="custom-img">
                            <img src="<?php echo e(asset('assets/images/auth/' . $color . '.png')); ?>" alt="login-banner"
                                width="100%" loading="lazy">

                        </div>
                    </div>
                    <div class="col-xl-5 col-12">
                        <div class="card">

                            <div class="card-body">
                                <div>
                                    <h2 class="mb-3 f-w-600"><?php echo e(__('Search Your Ticket')); ?></h2>
                                </div>
                                <form method="POST">

                                    <?php echo csrf_field(); ?>
                                    <?php if(session()->has('info')): ?>
                                        <div class="alert alert-success">
                                            <?php echo e(session()->get('info')); ?>

                                        </div>
                                    <?php endif; ?>
                                    <?php if(session()->has('status')): ?>
                                        <div class="alert alert-info">
                                            <?php echo e(session()->get('status')); ?>

                                        </div>
                                    <?php endif; ?>

                                    <div class="custom-login-form">
                                        <div class="">
                                            <div class="form-group mb-3">
                                                <label for="ticket_id" class="form-label"><?php echo e(__('Ticket Number')); ?></label>
                                                <input type="number"
                                                    class="form-control <?php echo e($errors->has('ticket_id') ? 'is-invalid' : ''); ?>"
                                                    min="0" id="ticket_id" name="ticket_id"
                                                    placeholder="<?php echo e(__('Enter Ticket Number')); ?>" required=""
                                                    value="<?php echo e(old('ticket_id')); ?>" autofocus>
                                                <div class="invalid-feedback d-block">
                                                    <?php echo e($errors->first('ticket_id')); ?>

                                                </div>
                                            </div>
                                            <div class="form-group mb-3">
                                                <label for="email" class="form-label"><?php echo e(__('Email')); ?></label>
                                                <input type="email"
                                                    class="form-control <?php echo e($errors->has('email') ? 'is-invalid' : ''); ?>"
                                                    id="email" name="email" placeholder="<?php echo e(__('Email address')); ?>"
                                                    reuired="" value="<?php echo e(old('email')); ?>">
                                                <div class="invalid-feedback d-block">
                                                    <?php echo e($errors->first('email')); ?>

                                                </div>
                                            </div>
                                            <div class="d-grid">
                                                <button
                                                    class="btn btn-primary btn-submit btn-block mt-2"><?php echo e(__('Search')); ?></button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
            <footer>
                <div class="auth-footer">
                    <div class="container">
                        <div class="row">
                            <div class="col-12">
                                <span>&copy; <?php echo e(date('Y')); ?>

                                    <?php echo e(App\Models\Utility::getValByName('footer_text') ? App\Models\Utility::getValByName('footer_text') : config('app.name', 'TicketGo')); ?>

                                    </span>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mycdsir/public_html/resources/views/search.blade.php ENDPATH**/ ?>